require "Items/ProceduralDistributions"

local TABAS_Distributions = {}

local bathItemsLootTables = {
    BathroomCounter = 8,
    BathroomCounterMotel = 20,
    BathroomShelf = 10,
    ChangeroomCounters = 10,
    DaycareCounter = 10,
    GigamartBathing = 20,
    -- PharmacyCosmetics = 4,
    -- PrisonCellRandom = 4,
    -- PrisonCellRandomClassy = 4,
    -- StoreKitchenCleaning = 8,
}

function TABAS_Distributions.addBathItemDistribution(item, multiplier)
    local distributions = ProceduralDistributions.list
    local mul = multiplier or 1
    for k, v in pairs(bathItemsLootTables) do
        table.insert(distributions[k].items, item)
        table.insert(distributions[k].items, v * mul)
    end
end

TABAS_Distributions.addBathItemDistribution("TABAS.BodyShampoo")
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Lavender", 0.5)
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Citrus", 0.5)
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Floral", 0.5)
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Forest", 0.5)
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Herb", 0.5)
TABAS_Distributions.addBathItemDistribution("TABAS.BathSalt_Rose", 0.5)
